/*
 * Decompiled with CFR 0.152.
 */
package org.jcochran.j2mechat;

import java.io.InterruptedIOException;
import java.util.Vector;
import org.jcochran.j2mechat.HelloMidlet;
import org.jcochran.j2mechat.JavaTOC;
import org.jcochran.j2mechat.TocErrors;
import org.jcochran.j2mechat.aimEvent;
import org.jcochran.j2mechat.infoThread;

public class loginThread
extends Thread {
    private String userName;
    private String passWord;
    private JavaTOC tc;
    private boolean isRunning = true;
    private Vector events = null;
    private HelloMidlet hm;
    private int port = 9898;

    public loginThread(String UserName, String PassWord, HelloMidlet hm) {
        this.userName = UserName;
        this.passWord = PassWord;
        this.hm = hm;
    }

    public loginThread(String UserName, String PassWord, HelloMidlet hm, int tocPort) {
        this.userName = UserName;
        this.passWord = PassWord;
        this.hm = hm;
        this.port = tocPort;
    }

    public void run() {
        if (this.tc == null) {
            this.tc = new JavaTOC();
        }
        this.tc.setTocPort(this.port);
        this.isRunning = true;
        try {
            this.events = new Vector();
            if (this.tc.login(this.userName, this.passWord)) {
                this.hm.showBuddyList();
            } else {
                TocErrors te = new TocErrors();
                String err = te.getErr(this.tc.getErr().trim());
                te = null;
                this.hm.showNetworkError("Network Error: " + err);
                this.tc = null;
                this.isRunning = false;
            }
        }
        catch (Exception e) {
            this.hm.showNetworkError(this.tc.getErr());
            this.tc = null;
            this.isRunning = false;
        }
        try {
            while (this.isRunning) {
                try {
                    aimEvent e = this.tc.processTOCEvents();
                    if (e != null) {
                        if (e.getEventType().equals("UPDATE_BUDDY2")) {
                            this.updateBuddy(e);
                        } else if (e.getEventType().equals("IM_IN2")) {
                            this.incomingIM(e);
                        } else if (e.getEventType().equals("CONFIG2")) {
                            this.doConfig(e);
                        } else if (e.getEventType().equals("GOTO_URL")) {
                            this.doInfo(e);
                        }
                        e = null;
                    }
                }
                catch (InterruptedIOException ioe) {
                    if (this.isRunning) {
                        this.hm.showNetworkError("Network Error: Connection was lost");
                        this.hm.doSignOff();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Thread.yield();
                this.trySleep(150);
            }
        }
        catch (Exception e) {
            System.out.println("TOC Thread: " + e.toString());
        }
    }

    private synchronized void doConfig(aimEvent e) {
        String eventStr = e.getEventPayload();
        System.out.println(eventStr.indexOf("\n"));
        String currentGroup = "Default";
        while (eventStr.indexOf("\n") > -1) {
            String eve = eventStr.substring(0, eventStr.indexOf("\n"));
            System.out.println("doConfig: " + eve);
            eventStr = eventStr.substring(eventStr.indexOf("\n") + 1, eventStr.length());
            if (eve.indexOf("m:") == 0) {
                this.hm.setPrivacy(Integer.parseInt(eve.substring(2, eve.length())));
            }
            eventStr = eventStr.substring(eventStr.indexOf("\n") + 1, eventStr.length());
            if (eve.indexOf("g:") == 0) {
                if (!currentGroup.equals(eve.substring(2, eve.length()))) {
                    // empty if block
                }
                currentGroup = eve.substring(2, eve.length());
            }
            if (eve.indexOf("b:") == 0) {
                // empty if block
            }
            eventStr = eventStr.substring(eventStr.indexOf("\n") + 1, eventStr.length());
        }
        eventStr = null;
        e = null;
        this.hm.doSetProfile();
    }

    private synchronized void doInfo(aimEvent e) {
        String url = e.getEventPayload().substring(e.getEventPayload().indexOf(":") + 1, e.getEventPayload().length());
        System.out.println(url);
        System.out.println(e.getEventPayload());
        infoThread it = new infoThread(url, this.hm, "");
        it.run();
    }

    private synchronized void setPriOpt(int PrivOpt) {
        this.tc.setPriOpt(PrivOpt);
    }

    public synchronized void setUserProfile(String profileInfo) {
        this.tc.setInfo(profileInfo);
    }

    public void setAway(String awayMsg) {
        this.tc.setAway(awayMsg);
    }

    private synchronized void sendIM(String toUser, String message) {
        this.tc.send(toUser, message);
    }

    public void setShouldStop() {
        this.isRunning = false;
        System.out.println("Closing");
    }

    private synchronized void incomingIM(aimEvent e) {
        String payload = e.getEventPayload();
        String buddyName = payload.substring(0, payload.indexOf(":"));
        payload = payload.substring(payload.indexOf(":") + 1, payload.length());
        String autoResp = payload.substring(0, 1);
        payload = payload.substring(payload.indexOf(":") + 1, payload.length());
        payload = payload.substring(payload.indexOf(":") + 1, payload.length());
        this.hm.incomingIM(buddyName, payload);
        payload = null;
        buddyName = null;
        autoResp = null;
    }

    private synchronized void updateBuddy(aimEvent e) {
        try {
            String payload = e.getEventPayload();
            String buddyName = payload.substring(0, payload.indexOf(":"));
            payload = payload.substring(payload.indexOf(":") + 1, payload.length());
            String type = payload.substring(0, 1);
            String status = payload.substring(0, payload.lastIndexOf(58));
            status = status.substring(status.lastIndexOf(58) + 1, status.length());
            if (!type.toLowerCase().equals("f")) {
                this.hm.get_BuddyList().AddBuddy(buddyName, type, status, 0);
            } else {
                this.hm.get_BuddyList().RemoveBuddy(buddyName, false);
            }
            buddyName = null;
            status = null;
            type = null;
            payload = null;
            e = null;
        }
        catch (Exception ef) {
            System.out.println("updateBuddy: " + ef.toString());
        }
    }

    private void trySleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public synchronized JavaTOC getJavaToc() {
        return this.tc;
    }
}

