/*
 * Decompiled with CFR 0.152.
 */
package org.jcochran.j2mechat;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import org.jcochran.j2mechat.HelloMidlet;

public class Notification {
    private boolean m_bVibrate = false;
    private boolean m_bNoise = false;
    private boolean m_bSignOn = false;
    private boolean m_bSignOff = false;
    private boolean m_bNewMessage = false;
    private boolean m_bSendMessage = false;
    private boolean m_bFirstMessage = false;
    private HelloMidlet m_parent = null;

    public void setParent(HelloMidlet hm) {
        this.m_parent = hm;
    }

    public void setVibrate(boolean bValue) {
        this.m_bVibrate = bValue;
    }

    public void setNoise(boolean bValue) {
        this.m_bNoise = bValue;
    }

    public void setSignOn(boolean bValue) {
        this.m_bSignOn = bValue;
    }

    public void setSignOff(boolean bValue) {
        this.m_bSignOff = bValue;
    }

    public void setNewMessage(boolean bValue) {
        this.m_bNewMessage = bValue;
    }

    public void setSendMessage(boolean bValue) {
        this.m_bSendMessage = bValue;
    }

    public void setFirstMessage(boolean bValue) {
        this.m_bFirstMessage = bValue;
    }

    public void signOn() {
        if (this.m_bSignOn) {
            this.doNotify(95, 750, 500);
        }
    }

    public void signOff() {
        if (this.m_bSignOff) {
            this.doNotify(110, 750, 500);
        }
    }

    public void newMessage() {
        if (this.m_bNewMessage) {
            this.doNotify(60, 1000, 500);
        }
    }

    public void sendMessage() {
        if (this.m_bSendMessage) {
            this.doNotify(80, 750, 500);
        }
    }

    public void firstMessage() {
        if (this.m_bFirstMessage) {
            this.doNotify(40, 1000, 500);
        } else {
            this.newMessage();
        }
    }

    private void doNotify(int nNote, int nNoiseDuration, int nVibeDuration) {
        try {
            if (this.m_bVibrate) {
                this.doVibration(nVibeDuration);
            }
            if (this.m_bNoise) {
                this.doNoise(nNote, nNoiseDuration);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void sendNewMessageAlert(String sText, Displayable disp) {
        if (this.m_bNewMessage) {
            this.sendAlert(sText, disp);
        }
    }

    public void sendFirstMessageAlert(String sText, Displayable disp) {
        if (this.m_bFirstMessage) {
            this.sendAlert(sText, disp);
        } else {
            this.sendNewMessageAlert(sText, disp);
        }
    }

    public void sendAlert(String sText, Displayable disp) {
        Alert alert = new Alert("Alert", sText, null, null);
        alert.setTimeout(-2);
        alert.setCommandListener(null);
        if (this.m_parent.getDisplay() != null) {
            this.m_parent.getDisplay().setCurrent((Displayable)alert);
        }
    }

    private void doNoise(int nNote, int nDuration) {
        try {
            Manager.playTone((int)nNote, (int)nDuration, (int)50);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void doVibration(int nDuration) {
        if (this.m_parent.getDisplay() != null) {
            this.m_parent.getDisplay().vibrate(nDuration);
        }
    }
}

